"""create virtual_card_purchases card

Revision ID: ddb964a11147
Revises: cbb76f58ac5c
Create Date: 2025-11-15 12:38:02.737667

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'ddb964a11147'
down_revision: Union[str, None] = 'cbb76f58ac5c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cards', sa.Column('balance', sa.Float(), nullable=False))
    op.add_column('cards', sa.Column('price', sa.Integer(), nullable=False))
    op.add_column('cards', sa.Column('currency', sa.String(length=5), nullable=False))
    op.drop_index('ix_cards_uid', table_name='cards')
    op.drop_column('cards', 'uid')
    op.drop_column('virtual_cards', 'currency')
    op.drop_column('virtual_cards', 'price')
    op.drop_column('virtual_cards', 'balance')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('virtual_cards', sa.Column('balance', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False))
    op.add_column('virtual_cards', sa.Column('price', sa.INTEGER(), autoincrement=False, nullable=False))
    op.add_column('virtual_cards', sa.Column('currency', sa.VARCHAR(length=5), autoincrement=False, nullable=False))
    op.add_column('cards', sa.Column('uid', sa.VARCHAR(length=50), autoincrement=False, nullable=False))
    op.create_index('ix_cards_uid', 'cards', ['uid'], unique=True)
    op.drop_column('cards', 'currency')
    op.drop_column('cards', 'price')
    op.drop_column('cards', 'balance')
    # ### end Alembic commands ###
