"""Ajoute de la table USer admin

Revision ID: 1eefb9e0637b
Revises: cd5d964144b1
Create Date: 2025-11-22 08:25:09.123997

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1eefb9e0637b'
down_revision: Union[str, None] = 'cd5d964144b1'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('admin_users', sa.Column('is_admin', sa.Boolean(), nullable=True))
    op.add_column('admin_users', sa.Column('active', sa.Boolean(), nullable=True))
    op.add_column('admin_users', sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True))
    op.add_column('admin_users', sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True))
    op.drop_column('users', 'is_admin')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('users', sa.Column('is_admin', sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.drop_column('admin_users', 'updated_at')
    op.drop_column('admin_users', 'created_at')
    op.drop_column('admin_users', 'active')
    op.drop_column('admin_users', 'is_admin')
    # ### end Alembic commands ###
