# Installation de MySQL sur Windows pour TIM CASH

## 🎯 Options d'Installation

### Option 1: Installation via l'installeur officiel (Recommandée)

#### Étape 1: Télécharger MySQL
1. Visitez: https://dev.mysql.com/downloads/installer/
2. Téléchargez **MySQL Installer for Windows** (version "mysql-installer-community")
3. Choisissez la version "web" (~2MB) ou "full" (~400MB)

#### Étape 2: Installer MySQL
1. Exécutez l'installeur téléchargé
2. Choisissez "Developer Default" ou "Server only"
3. Cliquez sur "Execute" pour télécharger et installer les composants

#### Étape 3: Configuration MySQL
1. **Type and Networking**:
   - Config Type: Development Computer
   - Port: 3306 (par défaut)
   - Cochez "Open Windows Firewall ports for network access"

2. **Authentication Method**:
   - Choisissez "Use Strong Password Encryption"

3. **Accounts and Roles**:
   - Définissez un mot de passe ROOT (notez-le bien!)
   - Exemple: `Root123!` (changez-le en production)

4. **Windows Service**:
   - Nom du service: MySQL80 (par défaut)
   - Cochez "Start the MySQL Server at System Startup"
   - Run Windows Service as: "Standard System Account"

5. **Apply Configuration**:
   - Cliquez sur "Execute" et attendez la fin
   - Cliquez sur "Finish"

#### Étape 4: Vérifier l'installation
```powershell
# Vérifier que le service est démarré
net start | findstr MySQL

# Tester la connexion (remplacez ROOT_PASSWORD par votre mot de passe)
mysql -u root -p
```

### Option 2: Installation via Chocolatey (Rapide)

```powershell
# Installer Chocolatey si non installé
# Voir: https://chocolatey.org/install

# Installer MySQL
choco install mysql -y

# Démarrer le service
net start MySQL80

# Configurer le mot de passe root
mysql -u root --skip-password
```

Dans la console MySQL:
```sql
ALTER USER 'root'@'localhost' IDENTIFIED BY 'VotreMotDePasse';
FLUSH PRIVILEGES;
EXIT;
```

### Option 3: XAMPP (Plus simple, inclut Apache/PHP)

1. Téléchargez XAMPP: https://www.apachefriends.org/
2. Installez XAMPP
3. Ouvrez le XAMPP Control Panel
4. Démarrez MySQL
5. Par défaut, root n'a pas de mot de passe (sécurisez-le!)

## ⚙️ Configuration Post-Installation

### 1. Créer l'utilisateur et la base TIM CASH

**Méthode A: Script automatique Python**
```powershell
cd C:\TIMCASH_V2\frontnew\backend
python setup_mysql_interactive.py
```

**Méthode B: Commandes MySQL manuelles**
```powershell
# Se connecter à MySQL
mysql -u root -p

# Dans la console MySQL:
```

```sql
-- Créer la base de données
CREATE DATABASE timcash_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Créer l'utilisateur
CREATE USER 'timcash'@'localhost' IDENTIFIED BY 'timcash123';

-- Accorder les privilèges
GRANT ALL PRIVILEGES ON timcash_db.* TO 'timcash'@'localhost';
FLUSH PRIVILEGES;

-- Vérifier
SHOW DATABASES;
SELECT user, host FROM mysql.user WHERE user = 'timcash';

-- Quitter
EXIT;
```

### 2. Tester la connexion
```powershell
mysql -u timcash -p timcash_db
# Mot de passe: timcash123
```

## 🚀 Prochaines Étapes

Une fois MySQL installé et configuré:

```powershell
# 1. Copier la configuration
copy .env.mysql .env

# 2. Vérifier l'état
python check_mysql_status.py

# 3. Exécuter la migration
python migrate_sqlite_to_mysql.py
```

## 🔧 Dépannage

### Erreur: "Port 3306 already in use"
Un autre service utilise le port 3306. Options:
1. Arrêtez l'autre service
2. Changez le port MySQL lors de l'installation (ex: 3307)

### Erreur: "Service won't start"
```powershell
# Vérifier les logs
notepad "C:\ProgramData\MySQL\MySQL Server 8.0\Data\*.err"

# Réinitialiser le service
sc delete MySQL80
# Puis réinstallez
```

### Mot de passe root oublié
```powershell
# Arrêter MySQL
net stop MySQL80

# Créer un fichier reset.txt avec:
# ALTER USER 'root'@'localhost' IDENTIFIED BY 'NouveauMotDePasse';

# Démarrer MySQL avec le fichier
mysqld --init-file=C:\path\to\reset.txt

# Redémarrer normalement
net start MySQL80
```

## 📌 Informations de Connexion par Défaut

Après installation pour TIM CASH:
- **Host**: localhost
- **Port**: 3306
- **Base de données**: timcash_db
- **Utilisateur**: timcash
- **Mot de passe**: timcash123

⚠️ **Changez ces valeurs en production!**
