from models.models import AdminStock
from sqlalchemy.orm import Session

def get_admin_stock(db: Session):
    stock = db.query(AdminStock).first()
    if not stock:
        stock = AdminStock(
            balance=847000000.0,  # 847M FCFA
            total_credits=0.0,
            total_debits=0.0,
            total_commissions=0.0
        )
        db.add(stock)
        db.commit()
        db.refresh(stock)
    return stock