from datetime import datetime

from pydantic import BaseModel


class LoanRequestWithInfo(BaseModel):
    amount: float
    date_naissance: datetime
    
class UserSchema(BaseModel):
    id: int
    name: str

    class Config:
        orm_mode = True


class LoanSchema(BaseModel):
    id: int
    amount: float
    user: UserSchema   # 

    class Config:
        orm_mode = True

class RepayLoanRequest(BaseModel):
    user_id: str
    loan_id: str
    amount: float
    
class RepayLoanResponseSchema(BaseModel):
    message: str
    remaining_balance: float
    penalty_applied: float
    days_overdue: int
    loan_status: str

class CommissionRequest(BaseModel):
    amount: float