from pydantic import BaseModel, EmailStr, Field
from typing import Optional
from datetime import datetime

    
class AdminCreateRequest(BaseModel):
    full_name : str
    phone_number : str
    email : EmailStr
    password :str
    role: str 
    
class AdminResponse(BaseModel):
    id: str
    full_name : str
    phone_number : str
    email : EmailStr
    active: bool
    is_admin: bool
    role: str 
    created_at: datetime
    updated_at: Optional[datetime] = None

    class Config:
        from_attributes = True

class LoginSchemaAdmin(BaseModel):
    email: EmailStr
    hashed_password: str