"""add prelevement request notifications

Revision ID: bb8be3e042ae
Revises: 7a843239a797
Create Date: 2025-11-24 02:02:01.009205

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'bb8be3e042ae'
down_revision: Union[str, None] = '7a843239a797'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('notifications', sa.Column('prelevement_id', sa.String(), nullable=True))
    op.drop_constraint('notifications_transaction_id_fkey', 'notifications', type_='foreignkey')
    op.create_foreign_key(None, 'notifications', 'prelevement', ['prelevement_id'], ['id'])
    op.create_foreign_key(None, 'notifications', 'transactions', ['transaction_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'notifications', type_='foreignkey')
    op.drop_constraint(None, 'notifications', type_='foreignkey')
    op.create_foreign_key('notifications_transaction_id_fkey', 'notifications', 'prelevement', ['transaction_id'], ['id'])
    op.drop_column('notifications', 'prelevement_id')
    # ### end Alembic commands ###
