"""Ajoute de phone pour la carte

Revision ID: 9898105bfe8f
Revises: c0db46f215fd
Create Date: 2026-01-02 19:14:33.754924

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '9898105bfe8f'
down_revision: Union[str, None] = 'c0db46f215fd'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cards', sa.Column('phone', sa.String(length=50), nullable=False))
    op.drop_index('ix_cards_uid', table_name='cards')
    op.create_index(op.f('ix_cards_phone'), 'cards', ['phone'], unique=True)
    op.drop_column('cards', 'uid')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cards', sa.Column('uid', sa.VARCHAR(length=50), autoincrement=False, nullable=False))
    op.drop_index(op.f('ix_cards_phone'), table_name='cards')
    op.create_index('ix_cards_uid', 'cards', ['uid'], unique=True)
    op.drop_column('cards', 'phone')
    # ### end Alembic commands ###
