#!/usr/bin/env python3
"""
Script pour supprimer tous les utilisateurs de la base de données
ATTENTION: Cette opération est irréversible!
"""

from sqlalchemy import create_engine, text
from sqlalchemy.orm import sessionmaker
import os
from dotenv import load_dotenv

# Charger les variables d'environnement
load_dotenv()

# Configuration de la base de données
DATABASE_URL = os.getenv('DATABASE_URL', 'mysql+pymysql://root:@localhost:3306/timcash_db')

# Créer le moteur et la session
engine = create_engine(DATABASE_URL, echo=True)
SessionLocal = sessionmaker(bind=engine)

def clear_users():
    """Supprime tous les utilisateurs de la base de données"""
    session = SessionLocal()
    
    try:
        print("\n" + "="*60)
        print("SUPPRESSION DES UTILISATEURS")
        print("="*60)
        
        # Compter les utilisateurs avant suppression
        count_query = text("SELECT COUNT(*) FROM users")
        result = session.execute(count_query)
        count_before = result.scalar()
        
        print(f"\n📊 Nombre d'utilisateurs avant: {count_before}")
        
        if count_before == 0:
            print("✅ Aucun utilisateur à supprimer!")
            return
        
        # Supprimer tous les utilisateurs
        delete_query = text("DELETE FROM users")
        session.execute(delete_query)
        session.commit()
        
        # Vérifier après suppression
        result = session.execute(count_query)
        count_after = result.scalar()
        
        print(f"📊 Nombre d'utilisateurs après: {count_after}")
        print(f"✅ {count_before} utilisateur(s) supprimé(s)!")
        print("="*60)
        
    except Exception as e:
        session.rollback()
        print(f"❌ Erreur lors de la suppression: {e}")
        raise
    finally:
        session.close()

if __name__ == "__main__":
    try:
        clear_users()
    except KeyboardInterrupt:
        print("\n\n⚠️  Opération annulée par l'utilisateur")
    except Exception as e:
        print(f"\n❌ Erreur: {e}")
