# Commission sur les Transferts - TIM CASH

## 📋 Règle de Commission

### Commission de 1% appliquée sur :

| Expéditeur | Destinataire | Commission | Exemple (10,000 FCFA) |
|------------|--------------|------------|----------------------|
| TIM MINI | TIM MINI | ✅ 1% | 100 FCFA |
| TIM MINI | TIM MAXI | ✅ 1% | 100 FCFA |
| TIM MAXI | TIM MINI | ✅ 1% | 100 FCFA |
| TIM MAXI | TIM MAXI | ✅ 1% | 100 FCFA |
| TIM MINI | TIM BUSINESS | ❌ 0% | 0 FCFA |
| TIM MAXI | TIM BUSINESS | ❌ 0% | 0 FCFA |
| TIM BUSINESS | TIM MINI | ❌ 0% | 0 FCFA |
| TIM BUSINESS | TIM MAXI | ❌ 0% | 0 FCFA |
| TIM BUSINESS | TIM BUSINESS | ❌ 0% | 0 FCFA |

## 🔧 Implémentation

### Endpoint : `POST /wallet/transfer`

**Logique de calcul** :
```python
# Calculer les frais de transfert selon les types de comptes
sender_type = current_user.tim_account_type
recipient_type = recipient.tim_account_type

# Appliquer 1% de commission pour :
# - TIM MINI → TIM MINI
# - TIM MINI → TIM MAXI
# - TIM MAXI → TIM MINI
# - TIM MAXI → TIM MAXI
# Pas de commission si TIM BUSINESS est impliqué
if sender_type in [TimAccountType.TIM_MINI, TimAccountType.TIM_MAXI] and \
   recipient_type in [TimAccountType.TIM_MINI, TimAccountType.TIM_MAXI]:
    transfer_fee = transfer_request.amount * 0.01  # 1% frais de transfert
else:
    transfer_fee = 0.0  # Pas de frais pour les transferts impliquant TIM BUSINESS
```

## 💰 Exemple de Transfert

### Scénario 1 : TIM MINI → TIM MINI (Commission appliquée)

**Données** :
- Expéditeur : Alice (TIM MINI) - Solde : 50,000 FCFA
- Destinataire : Bob (TIM MINI) - Solde : 10,000 FCFA
- Montant du transfert : 10,000 FCFA

**Calcul** :
- Montant : 10,000 FCFA
- Commission (1%) : 100 FCFA
- **Total débité** : 10,100 FCFA
- **Montant reçu** : 10,000 FCFA

**Résultat** :
- Alice : 50,000 - 10,100 = **39,900 FCFA**
- Bob : 10,000 + 10,000 = **20,000 FCFA**
- Stock Admin : +100 FCFA (commission)

### Scénario 2 : TIM MINI → TIM MAXI (Commission appliquée)

**Données** :
- Expéditeur : Alice (TIM MINI) - Solde : 50,000 FCFA
- Destinataire : Charlie (TIM MAXI) - Solde : 100,000 FCFA
- Montant du transfert : 20,000 FCFA

**Calcul** :
- Montant : 20,000 FCFA
- Commission (1%) : 200 FCFA
- **Total débité** : 20,200 FCFA
- **Montant reçu** : 20,000 FCFA

**Résultat** :
- Alice : 50,000 - 20,200 = **29,800 FCFA**
- Charlie : 100,000 + 20,000 = **120,000 FCFA**
- Stock Admin : +200 FCFA (commission)

### Scénario 3 : TIM MAXI → TIM MINI (Commission appliquée)

**Données** :
- Expéditeur : Charlie (TIM MAXI) - Solde : 100,000 FCFA
- Destinataire : Alice (TIM MINI) - Solde : 10,000 FCFA
- Montant du transfert : 15,000 FCFA

**Calcul** :
- Montant : 15,000 FCFA
- Commission (1%) : 150 FCFA
- **Total débité** : 15,150 FCFA
- **Montant reçu** : 15,000 FCFA

**Résultat** :
- Charlie : 100,000 - 15,150 = **84,850 FCFA**
- Alice : 10,000 + 15,000 = **25,000 FCFA**
- Stock Admin : +150 FCFA (commission)

### Scénario 4 : TIM MAXI → TIM MAXI (Commission appliquée)

**Données** :
- Expéditeur : Charlie (TIM MAXI) - Solde : 100,000 FCFA
- Destinataire : David (TIM MAXI) - Solde : 50,000 FCFA
- Montant du transfert : 10,000 FCFA

**Calcul** :
- Montant : 10,000 FCFA
- Commission (1%) : 100 FCFA
- **Total débité** : 10,100 FCFA
- **Montant reçu** : 10,000 FCFA

**Résultat** :
- Charlie : 100,000 - 10,100 = **89,900 FCFA**
- David : 50,000 + 10,000 = **60,000 FCFA**
- Stock Admin : +100 FCFA (commission)

### Scénario 5 : TIM BUSINESS → TIM MINI (PAS de commission)

**Données** :
- Expéditeur : Eve (TIM BUSINESS) - Solde : 500,000 FCFA
- Destinataire : Alice (TIM MINI) - Solde : 10,000 FCFA
- Montant du transfert : 30,000 FCFA

**Calcul** :
- Montant : 30,000 FCFA
- Commission : **0 FCFA** (pas de frais)
- **Total débité** : 30,000 FCFA
- **Montant reçu** : 30,000 FCFA

**Résultat** :
- Eve : 500,000 - 30,000 = **470,000 FCFA**
- Alice : 10,000 + 30,000 = **40,000 FCFA**
- Stock Admin : +0 FCFA (pas de commission)

## 📊 Transactions Créées

Pour chaque transfert, 2 transactions sont créées :

### Transaction Expéditeur (TRANSFER_OUT)
```json
{
  "transaction_type": "TRANSFER_OUT",
  "amount": -10100,  // Montant + commission
  "commission_amount": 100,
  "commission_rate": 0.01,
  "status": "COMPLETED",
  "description": "Transfert vers Bob - Description"
}
```

### Transaction Destinataire (TRANSFER_IN)
```json
{
  "transaction_type": "TRANSFER_IN",
  "amount": 10000,  // Montant sans commission
  "commission_amount": 0,
  "commission_rate": 0.0,
  "status": "COMPLETED",
  "description": "Transfert de Alice - Description"
}
```

## 🎯 Stock Admin

Les commissions sont automatiquement ajoutées au stock admin :

```python
if transfer_fee > 0:
    admin_stock = get_admin_stock(db)
    admin_stock.balance += transfer_fee
    admin_stock.total_commissions += transfer_fee
```

## 📱 API Response

```json
{
  "transfer_id": "uuid-here",
  "amount": 10000,
  "fee": 100,
  "recipient": "Bob Dupont",
  "status": "completed"
}
```

## ✅ Validation

### Vérifications effectuées :
1. ✅ Destinataire existe
2. ✅ Pas de transfert vers soi-même
3. ✅ Solde suffisant (montant + commission)
4. ✅ Limite du destinataire respectée
5. ✅ Type de compte pour calculer la commission

### Erreurs possibles :
- `404` : Destinataire non trouvé
- `400` : Transfert vers soi-même
- `400` : Solde insuffisant
- `400` : Dépassement de limite du destinataire

## 🧪 Tests

### Test 1 : TIM MINI → TIM MINI
```bash
POST /wallet/transfer
{
  "recipient_email": "bob@example.com",
  "amount": 10000,
  "description": "Test transfert"
}
```
**Résultat attendu** : Commission de 100 FCFA prélevée

### Test 2 : TIM MAXI → TIM MAXI
```bash
POST /wallet/transfer
{
  "recipient_email": "charlie@example.com",
  "amount": 10000,
  "description": "Test transfert"
}
```
**Résultat attendu** : Commission de 100 FCFA prélevée

### Test 3 : TIM BUSINESS → TIM MINI
```bash
POST /wallet/transfer
{
  "recipient_email": "alice@example.com",
  "amount": 10000,
  "description": "Test transfert"
}
```
**Résultat attendu** : Aucune commission prélevée

## 📝 Notes

- La commission est **toujours prélevée sur l'expéditeur**
- Le destinataire reçoit **le montant exact** demandé
- Les commissions sont **ajoutées au stock admin** automatiquement
- Les transactions sont **enregistrées dans la base de données**

---

**Date de création** : 26/10/2025 13:00  
**Version** : 1.0  
**Statut** : Implémenté et testé
