#!/usr/bin/env python3
"""
Extension simple de la base SQLite TIM CASH
"""

import os
import sys
from sqlalchemy import create_engine, inspect
from dotenv import load_dotenv

load_dotenv()

# Import des modèles au niveau module
from database import Base
from models.models import *
from extended_models import *

def simple_extend():
    """Extension simple de SQLite"""
    print("🚀 Extension simple de timcash.db")
    print("=" * 40)
    
    # Vérifier si la base existe
    if not os.path.exists("timcash.db"):
        print("❌ timcash.db non trouvé !")
        return False
    
    try:
        
        # Connexion SQLite
        engine = create_engine("sqlite:///timcash.db", connect_args={"check_same_thread": False})
        
        # Tables avant
        inspector = inspect(engine)
        tables_before = set(inspector.get_table_names())
        print(f"📋 Tables avant: {len(tables_before)}")
        
        # Créer toutes les tables
        Base.metadata.create_all(bind=engine)
        
        # Tables après
        inspector = inspect(engine)
        tables_after = set(inspector.get_table_names())
        new_tables = tables_after - tables_before
        
        print(f"✅ Tables après: {len(tables_after)}")
        if new_tables:
            print(f"🆕 Nouvelles tables ({len(new_tables)}):")
            for table in sorted(new_tables):
                print(f"   ✨ {table}")
        else:
            print("ℹ️ Aucune nouvelle table (toutes existent déjà)")
        
        print(f"\n📊 Taille de la base: {os.path.getsize('timcash.db')} bytes")
        print("🎉 Extension réussie !")
        return True
        
    except Exception as e:
        print(f"❌ Erreur: {e}")
        import traceback
        traceback.print_exc()
        return False

if __name__ == "__main__":
    simple_extend()
