# Script PowerShell - Affichage des informations de migration TIM CASH
# Usage: .\show_migration_info.ps1

Clear-Host

Write-Host ""
Write-Host "╔══════════════════════════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║                                                                      ║" -ForegroundColor Cyan
Write-Host "║           MIGRATION TIM CASH: SQLite → MySQL                         ║" -ForegroundColor Cyan
Write-Host "║                                                                      ║" -ForegroundColor Cyan
Write-Host "╚══════════════════════════════════════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

Write-Host "📊 ÉTAT ACTUEL" -ForegroundColor Yellow
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""

Write-Host "✅ PRÊT:" -ForegroundColor Green
Write-Host "   • Dépendances Python installées (PyMySQL, cryptography)"
Write-Host "   • Base SQLite source existe (timcash.db - 0.52 MB, 35 tables)"
Write-Host "   • Scripts de migration préparés"
Write-Host "   • Guides de documentation créés"
Write-Host ""

Write-Host "❌ À FAIRE:" -ForegroundColor Red
Write-Host "   • MySQL n'est pas installé ou démarré sur votre système"
Write-Host "   • Configuration MySQL nécessaire"
Write-Host ""

Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host "🚀 PROCESSUS DE MIGRATION (3 ÉTAPES SIMPLES)" -ForegroundColor Yellow
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""

Write-Host "┌─────────────────────────────────────────────────────────────────────┐" -ForegroundColor Cyan
Write-Host "│ ÉTAPE 1: INSTALLER MySQL (15-30 minutes)                            │" -ForegroundColor Cyan
Write-Host "└─────────────────────────────────────────────────────────────────────┘" -ForegroundColor Cyan
Write-Host ""
Write-Host "   🌐 Visitez: " -NoNewline
Write-Host "https://dev.mysql.com/downloads/installer/" -ForegroundColor Green
Write-Host ""
Write-Host "   📥 Téléchargez: 'MySQL Installer for Windows' (version Community)"
Write-Host ""
Write-Host "   ⚙️  Installation:"
Write-Host "      - Choisissez 'Developer Default' ou 'Server only'"
Write-Host "      - Définissez un mot de passe ROOT (notez-le!)"
Write-Host "      - Port: 3306 (défaut)"
Write-Host "      - Service: MySQL80 (auto-start)"
Write-Host ""
Write-Host "   ✅ Vérifiez l'installation:"
Write-Host "      PowerShell> " -NoNewline
Write-Host "net start | findstr MySQL" -ForegroundColor Yellow
Write-Host "      (Vous devriez voir 'MySQL80' démarré)"
Write-Host ""

Write-Host "┌─────────────────────────────────────────────────────────────────────┐" -ForegroundColor Cyan
Write-Host "│ ÉTAPE 2: CONFIGURER MySQL pour TIM CASH (5 minutes)                 │" -ForegroundColor Cyan
Write-Host "└─────────────────────────────────────────────────────────────────────┘" -ForegroundColor Cyan
Write-Host ""
Write-Host "   📂 Dans PowerShell:"
Write-Host "      python setup_mysql_interactive.py" -ForegroundColor Yellow
Write-Host ""
Write-Host "   📝 Le script vous demandera:"
Write-Host "      - Mot de passe MySQL root (défini à l'étape 1)"
Write-Host "      - Confirmera la création de la base 'timcash_db'"
Write-Host "      - Créera l'utilisateur 'timcash'"
Write-Host "      - Mettra à jour le fichier .env automatiquement"
Write-Host ""
Write-Host "   ✅ Le script fait TOUT automatiquement!"
Write-Host ""

Write-Host "┌─────────────────────────────────────────────────────────────────────┐" -ForegroundColor Cyan
Write-Host "│ ÉTAPE 3: MIGRER LES DONNÉES (5 minutes)                             │" -ForegroundColor Cyan
Write-Host "└─────────────────────────────────────────────────────────────────────┘" -ForegroundColor Cyan
Write-Host ""
Write-Host "   🔄 Dans PowerShell:"
Write-Host "      python migrate_sqlite_to_mysql.py" -ForegroundColor Yellow
Write-Host ""
Write-Host "   📦 Le script va:"
Write-Host "      ✓ Se connecter à SQLite et MySQL"
Write-Host "      ✓ Créer toutes les tables MySQL"
Write-Host "      ✓ Copier toutes les données (35 tables)"
Write-Host "      ✓ Vérifier l'intégrité"
Write-Host "      ✓ Afficher un rapport complet"
Write-Host ""
Write-Host "   🎉 Migration terminée!"
Write-Host ""

Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host "⚡ MÉTHODE ULTRA-RAPIDE (Script Batch)" -ForegroundColor Yellow
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""
Write-Host "Après avoir installé MySQL, double-cliquez sur:"
Write-Host "   migrate_to_mysql.bat" -ForegroundColor Green
Write-Host ""
Write-Host "Ce script vous guidera étape par étape de manière interactive!"
Write-Host ""

Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host "🔍 COMMANDES UTILES" -ForegroundColor Yellow
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""
Write-Host "Vérifier l'état complet:       " -NoNewline
Write-Host "python check_mysql_status.py" -ForegroundColor Yellow
Write-Host "Tester après migration:        " -NoNewline
Write-Host "python test_extended_tables.py" -ForegroundColor Yellow
Write-Host "Démarrer le serveur:           " -NoNewline
Write-Host "python -m uvicorn main:app --reload --port 8001" -ForegroundColor Yellow
Write-Host "Documentation API:             " -NoNewline
Write-Host "http://localhost:8001/docs" -ForegroundColor Green
Write-Host ""

Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host "📚 DOCUMENTATION DISPONIBLE" -ForegroundColor Yellow
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""
Write-Host "• " -NoNewline
Write-Host "README_MIGRATION.md          " -ForegroundColor Cyan -NoNewline
Write-Host "→ Démarrage rapide (1 page)"
Write-Host "• " -NoNewline
Write-Host "MIGRATION_STEPS.md           " -ForegroundColor Cyan -NoNewline
Write-Host "→ Guide pas-à-pas complet"
Write-Host "• " -NoNewline
Write-Host "install_mysql_windows.md     " -ForegroundColor Cyan -NoNewline
Write-Host "→ Installation MySQL détaillée"
Write-Host "• " -NoNewline
Write-Host "MIGRATION_MYSQL_GUIDE.md     " -ForegroundColor Cyan -NoNewline
Write-Host "→ Documentation technique complète"
Write-Host ""

Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""
Write-Host "💡 COMMENCEZ ICI: Installez MySQL depuis" -ForegroundColor Green
Write-Host "   https://dev.mysql.com/downloads/installer/" -ForegroundColor Green
Write-Host ""
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host "                    TIM CASH - Migration MySQL Ready 🚀" -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════════════════════════════════════" -ForegroundColor Yellow
Write-Host ""
