"""Ajoute de la table kyc

Revision ID: 35dfd12095d1
Revises: c4bc0277b1d7
Create Date: 2025-11-21 15:09:25.824912

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '35dfd12095d1'
down_revision: Union[str, None] = 'c4bc0277b1d7'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('kyc_verifications',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('document_type', sa.String(), nullable=False),
    sa.Column('document_number', sa.String(), nullable=False),
    sa.Column('document_front_image', sa.String(), nullable=False),
    sa.Column('document_back_image', sa.String(), nullable=True),
    sa.Column('selfie_image', sa.String(), nullable=True),
    sa.Column('status', sa.String(), nullable=True),
    sa.Column('submitted_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('reviewed_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('reviewer_id', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_kyc_verifications_id'), 'kyc_verifications', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_kyc_verifications_id'), table_name='kyc_verifications')
    op.drop_table('kyc_verifications')
    # ### end Alembic commands ###
