#!/usr/bin/env python3
"""
Lister toutes les villes de Côte d'Ivoire
"""

import pymysql

conn = pymysql.connect(
    host='localhost',
    user='timcash',
    password='timcash123',
    database='timcash_db',
    charset='utf8mb4'
)
cursor = conn.cursor()

# Récupérer toutes les villes de CI
cursor.execute("""
    SELECT c.name, c.branch_code, c.is_active, c.users, c.volume
    FROM cities c
    JOIN countries co ON c.country_id = co.id
    WHERE co.code = 'CI'
    ORDER BY c.name
""")

cities = cursor.fetchall()

print(f"\n🇨🇮 Villes de Côte d'Ivoire dans TIM CASH")
print("=" * 70)
print(f"📊 Total: {len(cities)} villes\n")

print(f"{'Ville':<25} {'Code Branche':<15} {'Actif':<8} {'Users':<8} {'Volume'}")
print("-" * 70)

for city in cities:
    name, branch_code, is_active, users, volume = city
    active_icon = "✅" if is_active else "❌"
    print(f"{name:<25} {branch_code:<15} {active_icon:<8} {users:<8} {volume:,.0f} FCFA")

print("=" * 70)
print(f"✅ {len([c for c in cities if c[2]])} villes actives")
print(f"📈 {sum([c[3] for c in cities])} utilisateurs au total")
print(f"💰 {sum([c[4] for c in cities]):,.0f} FCFA de volume total")

conn.close()
