"""
Script pour vider toutes les transactions (flux financiers)
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from database import SessionLocal
from models.models import Transaction

print("\n" + "="*60)
print("SUPPRESSION DES TRANSACTIONS (FLUX FINANCIERS)")
print("="*60)

db = SessionLocal()

try:
    # Compter les transactions avant suppression
    count_before = db.query(Transaction).count()
    
    print(f"\n📊 Nombre de transactions avant: {count_before}")
    
    if count_before == 0:
        print("✅ Aucune transaction à supprimer!")
    else:
        # Supprimer toutes les transactions
        deleted = db.query(Transaction).delete()
        db.commit()
        
        print(f"🗑️  {deleted} transaction(s) supprimée(s)")
        
        # Vérifier après suppression
        count_after = db.query(Transaction).count()
        print(f"📊 Nombre de transactions après: {count_after}")
        
        if count_after == 0:
            print("\n✅ Toutes les transactions ont été supprimées!")
        else:
            print(f"\n⚠️  Il reste encore {count_after} transaction(s)")
    
    print("="*60 + "\n")
    
except Exception as e:
    print(f"\n❌ Erreur: {str(e)}")
    db.rollback()
finally:
    db.close()
