# 💸 Guide de Configuration - Payout CinetPay (Retrait vers Mobile Money)

## 📋 Vue d'ensemble

Ce guide vous aide à configurer les **payouts** (retraits) pour permettre aux utilisateurs TIM MINI, TIM MAXI et TIM BUSINESS de transférer de l'argent de leur wallet TIM CASH vers leur compte Mobile Money.

### Opérateurs supportés
- ✅ **Wave** (Sénégal)
- ✅ **Orange Money** (Côte d'Ivoire, Mali, Sénégal)
- ✅ **MTN Money** (Côte d'Ivoire)
- ✅ **Moov Money** (Côte d'Ivoire)

---

## 🔐 Étape 1: Obtenir vos Credentials CinetPay

### 1.1 Connexion à votre compte CinetPay

1. Rendez-vous sur [https://client.cinetpay.com](https://client.cinetpay.com)
2. Connectez-vous avec vos identifiants

### 1.2 Récupérer votre API Key

1. Allez dans **Paramètres** → **API**
2. Copiez votre **API Key** (commence généralement par un nombre suivi de lettres)
   - Exemple: `27910410466fda66bbc6a87.93656172`

### 1.3 Définir votre mot de passe API

⚠️ **IMPORTANT**: Le mot de passe API est **différent** de votre mot de passe de connexion !

1. Dans **Paramètres** → **API**
2. Cherchez la section **"Mot de passe API"** ou **"API Password"**
3. Si vous n'en avez pas encore défini, créez-en un
4. **Notez ce mot de passe** en lieu sûr (vous en aurez besoin pour la configuration)

### 1.4 Activer l'API de Payout

1. Vérifiez que l'option **"Transfert d'argent"** ou **"Payout"** est activée
2. Si ce n'est pas le cas, contactez le support CinetPay pour l'activer

---

## ⚙️ Étape 2: Configuration du Backend

### 2.1 Modifier le fichier `.env.mysql`

Ouvrez le fichier `frontnew/backend/.env.mysql` et modifiez les lignes suivantes:

```env
# CinetPay Configuration
CINETPAY_API_KEY=27910410466fda66bbc6a87.93656172  # ✅ Déjà configuré
CINETPAY_SITE_ID=5880897                            # ✅ Déjà configuré
CINETPAY_SECRET_KEY=VOTRE_MOT_DE_PASSE_API_ICI     # ⚠️ À MODIFIER
CINETPAY_CALLBACK_URL=http://localhost:8001/api/mobile-money/callback
```

**Remplacez** `VOTRE_MOT_DE_PASSE_API_ICI` par le mot de passe API que vous avez défini à l'étape 1.3

### 2.2 Exemple de configuration complète

```env
# CinetPay Configuration
CINETPAY_API_KEY=27910410466fda66bbc6a87.93656172
CINETPAY_SITE_ID=5880897
CINETPAY_SECRET_KEY=MonMotDePasseAPISecurise123!
CINETPAY_CALLBACK_URL=http://localhost:8001/api/mobile-money/callback
```

### 2.3 Configuration pour la production

Pour la production, modifiez l'URL de callback:

```env
CINETPAY_CALLBACK_URL=https://votre-domaine.com/api/mobile-money/callback
```

---

## 🧪 Étape 3: Tester l'Authentification

### 3.1 Exécuter le script de test

Depuis le dossier `frontnew/backend`, exécutez:

```bash
python test_cinetpay_auth.py
```

### 3.2 Résultats attendus

Si la configuration est correcte, vous devriez voir:

```
✅ AUTHENTIFICATION RÉUSSIE !
🎫 Token généré: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...
⏰ Durée de validité: ~15 minutes
```

### 3.3 En cas d'erreur

Si vous voyez `❌ ÉCHEC DE L'AUTHENTIFICATION`, vérifiez:

1. ✅ Votre API Key est correcte
2. ✅ Votre mot de passe API est correct
3. ✅ Votre compte CinetPay est actif
4. ✅ L'API de payout est activée sur votre compte

---

## 📡 Étape 4: Comprendre le Flux de Payout

### 4.1 Processus d'authentification

```
┌─────────────────┐
│  TIM CASH API   │
└────────┬────────┘
         │
         │ 1. Demande de token
         ▼
┌─────────────────────────────────────────┐
│  POST https://client.cinetpay.com/v1/   │
│       auth/login?lang=fr                │
│                                         │
│  Content-Type: x-www-form-urlencoded   │
│  Body: apikey=xxx&password=xxx         │
└────────┬────────────────────────────────┘
         │
         │ 2. Réponse avec token
         ▼
┌─────────────────┐
│  Token JWT      │
│  Validité: 15min│
└─────────────────┘
```

### 4.2 Processus de transfert

```
┌──────────────┐
│ Utilisateur  │
│ TIM CASH     │
└──────┬───────┘
       │
       │ 1. Demande de retrait
       │    (montant, numéro, opérateur)
       ▼
┌──────────────────┐
│  Backend         │
│  TIM CASH        │
└──────┬───────────┘
       │
       │ 2. Vérifications
       │    - Solde suffisant
       │    - Numéro valide
       │    - Limites respectées
       │
       │ 3. Authentification CinetPay
       │    (obtenir token)
       ▼
┌──────────────────┐
│  CinetPay API    │
│  /transfer/money │
└──────┬───────────┘
       │
       │ 4. Initiation du transfert
       │
       │ 5. Callback asynchrone
       ▼
┌──────────────────┐
│  Mobile Money    │
│  (Wave, Orange,  │
│   MTN, Moov)     │
└──────────────────┘
```

---

## 🔧 Étape 5: Détails Techniques

### 5.1 Génération du Token

**URL**: `https://client.cinetpay.com/v1/auth/login`

**Méthode**: `POST`

**Headers**:
```
Content-Type: application/x-www-form-urlencoded
Accept: application/json
```

**Paramètres GET**:
```
lang: fr  (ou "en")
```

**Paramètres POST** (x-www-form-urlencoded):
```
apikey: votre-api-key
password: votre-mot-de-passe-api
```

**Réponse en cas de succès**:
```json
{
  "code": "00",
  "message": "SUCCESS",
  "data": {
    "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
    "user_id": "12345",
    "email": "votre-email@example.com"
  }
}
```

### 5.2 Envoi d'argent

**URL**: `https://client.cinetpay.com/v1/transfer/money/send/contact`

**Méthode**: `POST`

**Headers**:
```
Content-Type: application/x-www-form-urlencoded
```

**Paramètres GET**:
```
token: le-token-obtenu-lors-de-l-authentification
transaction_id: identifiant-unique-de-la-transaction
```

**Paramètres POST**:
```
data: [{"amount":"10000","phone":"0769989178","prefix":"225","notify_url":"..."}]
```

### 5.3 Gestion du Token

Le token est automatiquement géré par `CinetPayService`:

- ✅ **Cache**: Le token est mis en cache pour éviter les authentifications répétées
- ✅ **Expiration**: Le token expire après ~15 minutes
- ✅ **Renouvellement**: Le token est automatiquement renouvelé quand nécessaire
- ✅ **Thread-safe**: Le cache est partagé entre toutes les requêtes

---

## 💰 Étape 6: Commissions et Frais

### 6.1 Configuration des frais

Dans `.env.mysql`:

```env
# Taux de commission par défaut
WITHDRAWAL_COMMISSION_RATE=2.0  # 2% pour les retraits vers Mobile Money
```

### 6.2 Calcul des frais

Pour un retrait de **10,000 FCFA**:

```
Montant demandé:     10,000 FCFA
Commission (2%):        200 FCFA
─────────────────────────────────
Total débité:        10,200 FCFA
Montant reçu:        10,000 FCFA
```

---

## 🔒 Étape 7: Sécurité

### 7.1 Protection des credentials

⚠️ **NE JAMAIS** commiter le fichier `.env.mysql` avec vos vrais credentials !

Le fichier `.gitignore` doit contenir:
```
.env
.env.mysql
.env.local
.env.production
```

### 7.2 Variables d'environnement en production

En production, utilisez des variables d'environnement système:

```bash
export CINETPAY_API_KEY="votre-api-key"
export CINETPAY_SECRET_KEY="votre-mot-de-passe-api"
```

---

## 📊 Étape 8: Monitoring et Logs

### 8.1 Logs d'authentification

Les logs affichent:
```
🔐 Authentification CinetPay...
✅ Authentification CinetPay réussie
```

### 8.2 Logs de transfert

```
💸 Envoi de 10000 FCFA vers +2250769989178...
✅ Transfert initié avec succès: TXN-12345
```

### 8.3 Vérifier les transactions

Dans la base de données:
```sql
SELECT * FROM transactions 
WHERE transaction_type = 'MOBILE_MONEY_WITHDRAWAL' 
ORDER BY created_at DESC 
LIMIT 10;
```

---

## 🚀 Étape 9: Utilisation depuis l'Application Mobile

### 9.1 Endpoint API

```
POST /api/mobile-money/transfer
Authorization: Bearer {token}
Content-Type: application/json
```

### 9.2 Exemple de requête

```json
{
  "amount": 10000,
  "phone": "0769989178",
  "operator": "orange_ci",
  "description": "Retrait vers Orange Money"
}
```

### 9.3 Réponse en cas de succès

```json
{
  "success": true,
  "transaction_id": "TXN-abc123",
  "amount": 10000,
  "phone": "0769989178",
  "operator": "orange_ci",
  "status": "pending",
  "message": "Transfert en cours de traitement",
  "cinetpay_reference": "CP-xyz789"
}
```

---

## ❓ FAQ

### Q1: Combien de temps le token est-il valide ?
**R**: Le token est valide pendant environ **15 minutes**. Il est automatiquement renouvelé par le système.

### Q2: Que se passe-t-il si le transfert échoue ?
**R**: Le montant est automatiquement remboursé dans le wallet de l'utilisateur.

### Q3: Quels sont les délais de traitement ?
**R**: Les transferts sont généralement traités en **quelques secondes à quelques minutes** selon l'opérateur.

### Q4: Comment tester sans dépenser d'argent réel ?
**R**: Utilisez l'environnement de test (sandbox) de CinetPay si disponible, ou effectuez des petits transferts de test.

### Q5: Le mot de passe API est-il le même que mon mot de passe de connexion ?
**R**: **NON** ! Le mot de passe API est un mot de passe séparé que vous définissez dans les paramètres de votre compte CinetPay.

---

## 📞 Support

### Support CinetPay
- 📧 Email: support@cinetpay.com
- 🌐 Site: https://cinetpay.com
- 📚 Documentation: https://docs.cinetpay.com

### Support TIM CASH
- 📧 Email: support@timcash.ci
- 📱 Téléphone: +225 XX XX XX XX XX

---

## ✅ Checklist de Configuration

Avant de passer en production, vérifiez:

- [ ] API Key CinetPay configurée dans `.env.mysql`
- [ ] Mot de passe API CinetPay configuré dans `.env.mysql`
- [ ] Script de test exécuté avec succès
- [ ] Token généré correctement
- [ ] Callback URL configurée (production)
- [ ] Commissions configurées
- [ ] Logs activés
- [ ] Tests de transfert effectués
- [ ] Gestion des erreurs testée
- [ ] Documentation lue et comprise

---

**Date de création**: 2025-11-05  
**Version**: 1.0  
**Auteur**: TIM CASH Development Team

